<?php
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if(!empty($data->full_name) && !empty($data->email) && !empty($data->password)) {
    
    // Check if email exists
    $check_query = "SELECT user_id FROM users WHERE email = :email";
    $stmt = $db->prepare($check_query);
    $stmt->bindParam(':email', $data->email);
    $stmt->execute();
    
    if($stmt->rowCount() > 0){
        http_response_code(400);
        echo json_encode(array("message" => "Email already exists."));
        exit();
    }

    $query = "INSERT INTO users SET full_name=:name, email=:email, password=:password, phone_number=:phone, role=:role";
    $stmt = $db->prepare($query);

    $password_hash = password_hash($data->password, PASSWORD_BCRYPT);
    $role = !empty($data->role) ? $data->role : 'customer';

    $stmt->bindParam(":name", $data->full_name);
    $stmt->bindParam(":email", $data->email);
    $stmt->bindParam(":password", $password_hash);
    $stmt->bindParam(":phone", $data->phone_number);
    $stmt->bindParam(":role", $role);

    if($stmt->execute()) {
        http_response_code(201);
        echo json_encode(array("message" => "User registered successfully."));
    } else {
        http_response_code(503);
        echo json_encode(array("message" => "Unable to register user."));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
