<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->user_id)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing user_id"));
    exit();
}

$query = "UPDATE users SET full_name = :full_name, phone = :phone WHERE user_id = :user_id";

$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $data->user_id);
$stmt->bindParam(':full_name', $data->full_name);
$phone = isset($data->phone) ? $data->phone : '';
$stmt->bindParam(':phone', $phone);

if ($stmt->execute()) {
    // Fetch updated user data
    $fetch = "SELECT user_id, email, full_name, phone, role FROM users WHERE user_id = :user_id";
    $fetch_stmt = $db->prepare($fetch);
    $fetch_stmt->bindParam(':user_id', $data->user_id);
    $fetch_stmt->execute();
    $user = $fetch_stmt->fetch(PDO::FETCH_ASSOC);
    
    http_response_code(200);
    echo json_encode(array("message" => "Profile updated.", "user" => $user));
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Unable to update profile."));
}
?>
