<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

if (!isset($_FILES['image']) || !isset($_POST['user_id'])) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing image or user_id"));
    exit();
}

$user_id = $_POST['user_id'];
$file = $_FILES['image'];

$allowed_types = array('image/jpeg', 'image/png', 'image/gif', 'image/webp');
if (!in_array($file['type'], $allowed_types)) {
    http_response_code(400);
    echo json_encode(array("message" => "Invalid file type."));
    exit();
}

if ($file['size'] > 5 * 1024 * 1024) {
    http_response_code(400);
    echo json_encode(array("message" => "File too large. Max 5MB."));
    exit();
}

$upload_dir = '../uploads/profiles/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

$extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = 'user_' . $user_id . '_' . time() . '.' . $extension;
$filepath = $upload_dir . $filename;

if (move_uploaded_file($file['tmp_name'], $filepath)) {
    $image_url = 'http://localhost/bengkelku_api/uploads/profiles/' . $filename;
    
    $query = "UPDATE users SET profile_image = :image WHERE user_id = :user_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':image', $image_url);
    $stmt->bindParam(':user_id', $user_id);
    
    if ($stmt->execute()) {
        http_response_code(200);
        echo json_encode(array(
            "message" => "Profile image uploaded.",
            "image_url" => $image_url
        ));
    } else {
        http_response_code(503);
        echo json_encode(array("message" => "Failed to update database."));
    }
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Failed to upload image."));
}
?>
