<?php
include_once '../config/database.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die();

$query = "
    SELECT 
        b.booking_id, 
        b.status, 
        b.booking_time, 
        b.workshop_id, 
        w.name as workshop_name, 
        w.image as workshop_image,
        v.brand,
        v.model,
        v.plate_number,
        r.review_id
    FROM bookings b
    JOIN workshops w ON b.workshop_id = w.workshop_id
    LEFT JOIN vehicles v ON b.vehicle_id = v.vehicle_id
    LEFT JOIN reviews r ON b.booking_id = r.booking_id
    WHERE b.user_id = :user_id
    ORDER BY b.booking_time DESC
";

$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$num = $stmt->rowCount();

if($num > 0) {
    $bookings_arr = array();
    $bookings_arr["data"] = array();

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        $booking_item = array(
            "id" => $booking_id,
            "status" => $status,
            "date" => $booking_time,
            "workshop_id" => $workshop_id,
            "workshop_name" => $workshop_name,
            "workshop_image" => $workshop_image,
            "vehicle" => $brand . " " . $model . " (" . $plate_number . ")",
            "hasReview" => !empty($review_id)
        );
        array_push($bookings_arr["data"], $booking_item);
    }
    http_response_code(200);
    echo json_encode($bookings_arr);
} else {
    // Return empty array instead of 404 for empty state
    http_response_code(200);
    echo json_encode(array("data" => []));
}
?>
