<?php
header("Access-Control-Allow-Origin: *");
error_reporting(0); // Suppress warnings so they don't break JSON
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$booking_id = isset($_GET['booking_id']) ? $_GET['booking_id'] : null;

if (!$booking_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Validation Error: Missing Booking ID."));
    exit();
}

$query = "
    SELECT 
        b.booking_id, 
        b.booking_time, 
        b.status, 
        b.total_cost,
        b.notes,
        u.full_name as customer_name,
        u.phone_number as customer_phone,
        u.email as customer_email,
        w.name as workshop_name,
        w.address as workshop_address,
        v.brand,
        v.model,
        v.year,
        v.plate_number
    FROM bookings b
    JOIN users u ON b.user_id = u.user_id
    JOIN workshops w ON b.workshop_id = w.workshop_id
    LEFT JOIN vehicles v ON b.vehicle_id = v.vehicle_id
    WHERE b.booking_id = :booking_id
    LIMIT 0,1
";

$stmt = $db->prepare($query);
$stmt->bindParam(':booking_id', $booking_id);
$stmt->execute();

if($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // 2. Get Services Detail
    $service_query = "
        SELECT s.service_name, bd.price_at_booking 
        FROM booking_details bd
        JOIN services s ON bd.service_id = s.service_id
        WHERE bd.booking_id = :booking_id
    ";
    $stmt_services = $db->prepare($service_query);
    $stmt_services->bindParam(':booking_id', $booking_id);
    $stmt_services->execute();
    
    $services = $stmt_services->fetchAll(PDO::FETCH_ASSOC);

    // Format response
    $response = array(
        "booking_id" => $row['booking_id'],
        "status" => $row['status'],
        "date" => $row['booking_time'],
        "problem" => $row['notes'] ? $row['notes'] : 'Tidak ada deskripsi',
        "total_cost" => $row['total_cost'],
        "services" => $services, // Added services array
        "customer" => array(
            "name" => $row['customer_name'],
            "phone" => $row['customer_phone'],
            "email" => $row['customer_email']
        ),
        "vehicle" => array(
            "name" => $row['brand'] ? $row['brand'] . ' ' . $row['model'] : 'Kendaraan Tidak Diketahui',
            "plate" => $row['plate_number'],
            "year" => $row['year']
        ),
        "workshop" => array(
            "name" => $row['workshop_name'],
            "address" => $row['workshop_address']
        )
    );

    http_response_code(200);
    echo json_encode($response);
} else {
    http_response_code(404);
    echo json_encode(array("message" => "Order not found."));
}
?>
