<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$conversation_id = isset($_GET['conversation_id']) ? $_GET['conversation_id'] : null;
$current_user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

if (!$conversation_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing conversation_id"));
    exit();
}

// Mark messages as read for the other party
if ($current_user_id) {
    $mark_read = "UPDATE messages SET is_read = 1 WHERE conversation_id = :conv_id AND sender_id != :user_id";
    $mark_stmt = $db->prepare($mark_read);
    $mark_stmt->bindParam(':conv_id', $conversation_id);
    $mark_stmt->bindParam(':user_id', $current_user_id);
    $mark_stmt->execute();
}

// Get messages
$query = "
    SELECT m.message_id, m.conversation_id, m.sender_id, m.message, m.sent_at, m.is_read,
           u.full_name as sender_name
    FROM messages m
    JOIN users u ON m.sender_id = u.user_id
    WHERE m.conversation_id = :conversation_id
    ORDER BY m.sent_at ASC
";
$stmt = $db->prepare($query);
$stmt->bindParam(':conversation_id', $conversation_id);
$stmt->execute();

$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($messages);
?>
