<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->conversation_id) || empty($data->sender_id) || empty($data->message)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing required fields"));
    exit();
}

try {
    // Insert message
    $query = "INSERT INTO messages (conversation_id, sender_id, message) VALUES (:conv_id, :sender_id, :message)";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':conv_id', $data->conversation_id);
    $stmt->bindParam(':sender_id', $data->sender_id);
    $stmt->bindParam(':message', $data->message);
    $stmt->execute();
    
    $message_id = $db->lastInsertId();
    
    // Update last_message_at in conversation
    $update = "UPDATE conversations SET last_message_at = NOW() WHERE conversation_id = :conv_id";
    $upd_stmt = $db->prepare($update);
    $upd_stmt->bindParam(':conv_id', $data->conversation_id);
    $upd_stmt->execute();
    
    http_response_code(201);
    echo json_encode(array("message" => "Message sent.", "message_id" => $message_id));
    
} catch (Exception $e) {
    http_response_code(503);
    echo json_encode(array("message" => "Failed to send message. " . $e->getMessage()));
}
?>
