<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$owner_id = isset($_GET['owner_id']) ? $_GET['owner_id'] : null;

if (!$owner_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing owner_id"));
    exit();
}

// Get workshop_id for this owner
$workshop_query = "SELECT workshop_id FROM workshops WHERE owner_id = :owner_id LIMIT 1";
$workshop_stmt = $db->prepare($workshop_query);
$workshop_stmt->bindParam(':owner_id', $owner_id);
$workshop_stmt->execute();

if ($workshop_stmt->rowCount() == 0) {
    http_response_code(404);
    echo json_encode(array("message" => "Workshop not found for this owner"));
    exit();
}

$workshop = $workshop_stmt->fetch(PDO::FETCH_ASSOC);
$workshop_id = $workshop['workshop_id'];

// Get services for this workshop
$query = "SELECT service_id, service_name, price, category, description FROM services WHERE workshop_id = :workshop_id ORDER BY service_name ASC";
$stmt = $db->prepare($query);
$stmt->bindParam(':workshop_id', $workshop_id);
$stmt->execute();

$services = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($services);
?>
