<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$owner_id = isset($_GET['owner_id']) ? $_GET['owner_id'] : null;

if (!$owner_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing owner_id"));
    exit();
}

$query = "SELECT * FROM workshops WHERE owner_id = :owner_id LIMIT 1";
$stmt = $db->prepare($query);
$stmt->bindParam(':owner_id', $owner_id);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $workshop = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode($workshop);
} else {
    http_response_code(404);
    echo json_encode(array("message" => "Workshop not found"));
}
?>
