<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/database.php';

$booking_id = isset($_GET['booking_id']) ? $_GET['booking_id'] : null;

if (!$booking_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing booking_id"));
    exit();
}

$query = "SELECT r.*, u.full_name as reviewer_name FROM reviews r 
          JOIN users u ON r.user_id = u.user_id 
          WHERE r.booking_id = :booking_id LIMIT 1";
$stmt = $db->prepare($query);
$stmt->bindParam(':booking_id', $booking_id);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $review = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode(array("exists" => true, "review" => $review));
} else {
    echo json_encode(array("exists" => false));
}
?>
