<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->booking_id) || empty($data->user_id) || empty($data->workshop_id) || empty($data->rating)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing required fields"));
    exit();
}

// Check if review already exists for this booking
$check = "SELECT review_id FROM reviews WHERE booking_id = :booking_id";
$check_stmt = $db->prepare($check);
$check_stmt->bindParam(':booking_id', $data->booking_id);
$check_stmt->execute();

if ($check_stmt->rowCount() > 0) {
    http_response_code(400);
    echo json_encode(array("message" => "Review already submitted for this booking"));
    exit();
}

// Insert review
$query = "INSERT INTO reviews (booking_id, user_id, workshop_id, rating, comment) VALUES (:booking_id, :user_id, :workshop_id, :rating, :comment)";
$stmt = $db->prepare($query);
$stmt->bindParam(':booking_id', $data->booking_id);
$stmt->bindParam(':user_id', $data->user_id);
$stmt->bindParam(':workshop_id', $data->workshop_id);
$stmt->bindParam(':rating', $data->rating);
$comment = isset($data->comment) ? $data->comment : '';
$stmt->bindParam(':comment', $comment);

if ($stmt->execute()) {
    // Update workshop average rating
    $avg_query = "UPDATE workshops SET rating = (
        SELECT ROUND(AVG(rating), 1) FROM reviews WHERE workshop_id = :workshop_id
    ) WHERE workshop_id = :workshop_id2";
    $avg_stmt = $db->prepare($avg_query);
    $avg_stmt->bindParam(':workshop_id', $data->workshop_id);
    $avg_stmt->bindParam(':workshop_id2', $data->workshop_id);
    $avg_stmt->execute();
    
    http_response_code(201);
    echo json_encode(array("message" => "Review submitted successfully"));
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Failed to submit review"));
}
?>
