<?php
include_once 'config/database.php';

try {
    // 1. Clear existing data (Optional, to avoid duplicates if run multiple times)
    $db->exec("DELETE FROM booking_details");
    $db->exec("DELETE FROM bookings");
    $db->exec("DELETE FROM services");
    $db->exec("DELETE FROM vehicles");
    $db->exec("DELETE FROM workshops");
    $db->exec("DELETE FROM users");

    // 2. Insert Dummy Users
    // Password for all is '123456' (hashed)
    $password = password_hash("123456", PASSWORD_BCRYPT);
    
    $users_sql = "INSERT INTO users (user_id, full_name, email, password, role, phone_number) VALUES
    (1, 'Reana User', 'reana@example.com', '$password', 'customer', '08123456789'),
    (2, 'Pak Budi', 'budi@bengkel.com', '$password', 'owner', '08198765432'),
    (3, 'Mas Dian', 'dian@ban.com', '$password', 'owner', '08122334455')";
    $db->exec($users_sql);
    echo "Users inserted.<br>";

    // 2.5 Insert Dummy Vehicles
    $vehicles_sql = "INSERT INTO vehicles (vehicle_id, user_id, brand, model, year, plate_number) VALUES
    (1, 1, 'Honda', 'Vario 150', 2020, 'B 1234 CD'),
    (2, 1, 'Yamaha', 'NMAX', 2021, 'B 5678 EF')";
    $db->exec($vehicles_sql);
    echo "Vehicles inserted.<br>";

    // 3. Insert Workshops
    $workshops_sql = "INSERT INTO workshops (workshop_id, owner_id, name, description, address, latitude, longitude, is_open, rating, image_url) VALUES
    (1, 2, 'Bengkel Jaya Motor', 'Spesialis motor matic dan bebek.', 'Jl. Sudirman No. 45, Jakarta', -6.2088, 106.8456, 1, 4.8, 'https://images.unsplash.com/photo-1626885376717-h98w90s8gs8?auto=format&fit=crop&w=500&q=60'),
    (2, 3, 'Sumber Ban Abadi', 'Pusat ban motor lengkap dan nitrogen.', 'Jl. Thamrin No. 10, Jakarta', -6.1944, 106.8229, 1, 4.5, 'https://images.unsplash.com/photo-1599839572688-64478d59103c?auto=format&fit=crop&w=500&q=60'),
    (3, 2, 'Montir Keliling 24 Jam', 'Melayani servis panggilan darurat.', 'Area Jakarta Pusat', -6.1805, 106.8284, 0, 4.9, 'https://images.unsplash.com/photo-1632823471565-1eca35ac2f2a?auto=format&fit=crop&w=500&q=60')";
    $db->exec($workshops_sql);
    echo "Workshops inserted.<br>";

    // 4. Insert Services
    $services_sql = "INSERT INTO services (workshop_id, service_name, price, category, description) VALUES
    (1, 'Ganti Oli Mesin', 55000, 'servis_rutin', 'Oli MPX2 + Jasa'),
    (1, 'Servis CVT', 85000, 'servis_rutin', 'Pembersihan dan pengecekan roller/v-belt'),
    (1, 'Ganti Kampas Rem', 45000, 'servis_rutin', 'Depan/Belakang'),
    (2, 'Tambal Tubeless', 20000, 'tambal_ban', 'Per lubang'),
    (2, 'Isi Nitrogen', 5000, 'tambal_ban', 'Per ban'),
    (2, 'Ganti Ban Luar', 250000, 'servis_rutin', 'Termasuk jasa pasang'),
    (3, 'Servis Darurat', 100000, 'darurat', 'Biaya kunjungan')";
    $db->exec($services_sql);
    echo "Services inserted.<br>";

    echo "<h3>Database Seeded Successfully!</h3>";

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
