<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->service_id)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing service_id"));
    exit();
}

$query = "UPDATE services SET service_name = :service_name, price = :price, category = :category, description = :description WHERE service_id = :service_id";

$stmt = $db->prepare($query);
$stmt->bindParam(':service_id', $data->service_id);
$stmt->bindParam(':service_name', $data->service_name);
$stmt->bindParam(':price', $data->price);
$category = isset($data->category) ? $data->category : 'servis_rutin';
$description = isset($data->description) ? $data->description : '';
$stmt->bindParam(':category', $category);
$stmt->bindParam(':description', $description);

if ($stmt->execute()) {
    http_response_code(200);
    echo json_encode(array("message" => "Service updated."));
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Unable to update service."));
}
?>
