<?php
include_once 'config/database.php';

try {
    // Create conversations table
    $db->exec("
        CREATE TABLE IF NOT EXISTS conversations (
            conversation_id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            workshop_id INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            last_message_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(user_id),
            FOREIGN KEY (workshop_id) REFERENCES workshops(workshop_id),
            UNIQUE KEY unique_conv (user_id, workshop_id)
        )
    ");
    echo "Conversations table created.<br>";

    // Create messages table
    $db->exec("
        CREATE TABLE IF NOT EXISTS messages (
            message_id INT AUTO_INCREMENT PRIMARY KEY,
            conversation_id INT NOT NULL,
            sender_id INT NOT NULL,
            message TEXT NOT NULL,
            sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            is_read BOOLEAN DEFAULT FALSE,
            FOREIGN KEY (conversation_id) REFERENCES conversations(conversation_id),
            FOREIGN KEY (sender_id) REFERENCES users(user_id)
        )
    ");
    echo "Messages table created.<br>";

    echo "<h3>Chat tables created successfully!</h3>";

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
